<?php

namespace App\Http\Controllers;
use App\Models\Faq;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class FaqController extends Controller
{
    public function index()
    {
        $data["faq"] = Faq::orderBy('id', 'ASC')->get();

        return view('admin.faq.index')->with($data);
    }

    public function add_faq(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'question' => 'required',
            'answer' => 'required',
            'question_ar' => 'required',
            'answer_ar' => 'required',
        ]);

        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        $category = new Faq();
        $category->question = $request->question;
        $category->question_ar = $request->question_ar;
        $category->answer = $request->answer;
        $category->answer_ar = $request->answer_ar;
        $category->save();
        if ($category) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Added";
            $user_activity_log['activity_desc'] = 'New Faq ' . $request->question . ' Has Been Added By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Faq added successfully ']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }
    }

    public function faq_datatable(Request $request)
    {
        $limit = ($request->length != '') ? $request->length : 15;
        $offset = ($request->start != '') ? $request->start : 0;
        $search = $request->search['value'];
        $order = $request->order;
        $columns = $request->columns;
        $colName = 'tbl_faq.id';
        $sort = 'DESC';
        if (isset($order[0]['column']) && isset($order[0]['dir'])) {
            $colNo = $order[0]['column'];
            $sort = $order[0]['dir'];
            if (isset($columns[$colNo]['name'])) {
                $colName = $columns[$colNo]['name'];
            }
        }


        $category_data = $roles = Faq::Where(function ($query) use ($search) {
                $query->where('question', 'like', $search . '%');

            });
        if ($colName != '' && $sort != '') {
            $category_data->orderBy($colName, $sort);
        } else {
            $category_data->orderBy('id', 'DESC');
        }
        $data = ['iTotalDisplayRecords' => $category_data->count(), 'iTotalRecords' => $category_data->count(), 'TotalDisplayRecords' => $limit];
        $data['data'] = $category_data->skip($offset)->take($limit)->get()->toArray();
        return response()->json($data);
    }

    public function faq_view(Request $request)
    {
        $id = $request->id;
        $data['faq'] = Faq::find($id);

        return view('admin.faq.modal', compact('data'));
    }

    public function edit_faq(Request $request)
    {
        $id = $request->id;
        $data = Faq::find($id);

        return response()->json($data);
    }

    public function update_faq(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'question' => 'required',
            'answer' => 'required',
            'question_ar' => 'required',
            'answer_ar' => 'required',
        ]);

        if ($validator->fails()) {
            foreach (array_values($validator->messages()->toArray()) as $msg) {
                $error = implode(' ', $msg) . '<br>';
            }
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => $error]);
        }

        $update = Faq::find($request->category_id)->update([
            'question' => $request->question,
            'question_ar' => $request->question_ar,
            'answer' => $request->answer,
            'answer_ar' => $request->answer_ar,
        ]);
        if ($update == 1) {
            ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Updated";
            $user_activity_log['activity_desc'] = 'Faq ' . $request->title . ' Has Been Updated By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Faq updated successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }
    }

    public function delete_faq(Request $request)
    {
        Faq::find($request->id)->delete();

        return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Faq deleted successfully']);
    }
}
