<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests;
use Illuminate\Foundation\Bus\DispatchesJobs;
use Illuminate\Foundation\Validation\ValidatesRequests;
use Illuminate\Routing\Controller as BaseController;
use App\Models\notificationModel;
use Session;
use App\Models\user;
use App\Models\tableModel;
use Auth;

class Controller extends BaseController
{
    use AuthorizesRequests, DispatchesJobs, ValidatesRequests;
    public function set_light_mode(Request $request)
    {
        $class_name = $request->class;
        Session::put('light_mode_class_name', $class_name);
    }
    public function set_side_menu_view(Request $request)
    {
        if (session('side_menu_class_name') == "") {
            Session::put('side_menu_class_name', 'sidenav-toggled');
        } else {
            session()->forget('side_menu_class_name');
        }

    }

    public function set_sound_status(Request $request)
    {
        $status = $request->status;
        $update_user = user::where('id', Auth::user()->id)->update(['sound_effect' => $status]);
        return $status;
    }
    public function from_date_filter(Request $request)
    {
        $from_date = $request->from_date;
        Session::put('from_date', $from_date);
        $get_session_data = get_session_data();
        return $get_session_data;
    }
    public function to_date_filter(Request $request)
    {
        $to_date = $request->to_date;
        Session::put('to_date', $to_date);
        $get_session_data = get_session_data();
        return $get_session_data;

    }

    public function check_active_notification()
    {
        $check_notification_exist = notificationModel::where('notification_status', 0)->where('notification_seen_status', 0)->get()->toArray();
        $sound_status=Auth::user()->sound_effect;
        
        if (count($check_notification_exist) > 0  && Auth::user()->sound_effect==0) {
            return 0;
        } else {
            return 1;
        }
    }

    public function update_active_notification()
    {
        $update_notifications = notificationModel::where('notification_status', 0)->update(['notification_seen_status' => 1]);
        if ($update_notifications) {
            return 0;
        } else {
            return 1;
        }
    }

    public function get_table_datas(){
       $data['all_table']=tableModel::where('table_active_status',0)->get()->toArray();
       $data['available_tables']=tableModel::where('table_active_status',0)->where('table_tracking_status','Available')->get()->toArray();
       $data['reserved_tables']=tableModel::where('table_active_status',0)->where('table_tracking_status','Reserved')->get()->toArray();
        return response()->json($data);
    }

    public function update_table_status(Request $request){
        $table_id=$request->table_id;
        $details=tableModel::where('table_id',$table_id)->first();
        if($details){

            $table_status=$details->table_tracking_status;
            if($table_status=="Reserved"){
                    $updating_order="Available";
            }
            else if($table_status=="Available"){
                    $updating_order="Reserved";
            }

            $update=tableModel::where('table_id',$table_id)->update(['table_tracking_status'=>$updating_order]);
            if($update==1){
             ############################User Activity log#########################
            $user_activity_log['activity_ip'] = $request->ip();
            $user_activity_log['activity_user_name'] = Auth::user()->name;
            $user_activity_log['activity_user_id'] = Auth::user()->id;
            $user_activity_log['activity_action'] = "Updated";
            $user_activity_log['activity_desc'] = 'Table ' . $details->table_name . ' Status  Has Been Deleted By ' . Auth::user()->name;
            user_activity_log($user_activity_log);
            ###########################End Of USer Activity Log###################
            return response()->json(['status' => 0, 'heading' => 'Success', 'msg' => 'Table Updated successfully']);
        } else {
            return response()->json(['status' => 1, 'heading' => 'Error', 'msg' => 'Something Went Wrong']);
        }


            

        }
    }
}