<?php


namespace App\Http\Controllers\API;


use App\Http\Controllers\API\BaseController as BaseController;
use App\Models\ApiCartModel;
use App\Models\ApiCartRecipeAddOnModel;
use App\Models\ApiCartRecipeModel;
use App\Models\branchModel;
use App\Models\categoryModel;
use App\Models\customerModel;
use App\Models\Faq;
use App\Models\inventoryitemModel;
use App\Models\inventoryModel;
use App\Models\notificationModel;
use App\Models\order_item_add_onModel;
use App\Models\orderitemModel;
use App\Models\orderModel;
use App\Models\recipe_add_on_Model;
use App\Models\recipeModel;
use App\Models\subcategoryModel;
use App\Models\tableModel;
use App\Models\TalkToAgent;
use App\Models\Transaction;
use App\Traits\cartTrait;
use Barryvdh\DomPDF\Facade\Pdf;
use CURLFile;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Validator;
use Cart;
use Illuminate\Support\Facades\Log;
use App\Traits\websiteTrait;

class ApiController extends BaseController
{
    use cartTrait;

    public function menu_details(Request $request)
    {
        $menu = [
            'Place New Order',
            'Track My Order',
            'Locate Nearest Store',
            'Get Support',
        ];

        $exist = customerModel::where('customer_mob', $request->cid)->first();
        if ($exist) {
            $latest_cart = ApiCartModel::where('customer_id', $exist->customer_id)
                ->where('checkout_status', '!=', 2)
                ->get();

            $orders = ApiCartModel::where('customer_id', $exist->customer_id)
                ->where('checkout_status', 2)
                ->get();

            $orders_data = orderModel::where('order_customer_id', $exist->customer_id)
                ->whereIn('order_tracking_status', ['Placed', 'Approved'])
                ->get();

            if ($orders_data->count() > 0) {
                array_unshift($menu, 'Cancel Order');
            }

            if ($latest_cart->count() > 0) {
                array_unshift($menu, 'Show My Cart');
            }

            if ($orders->count() > 0) {
                array_unshift($menu, 'Previous Orders');
            }

            return response()->json([
                'status' => true,
                'menus' => $menu,
                'message' => '👋 Welcome to Restaurant! We’re excited to serve you delicious meals 🍔🍟 delivered fresh to your doorstep. 🏠',
            ], 200);
        } else {
            return response()->json([
                'status' => true,
                'menus' => $menu,
                'message' => '👋 Welcome to Restaurant! We’re excited to serve you delicious meals 🍔🍟 delivered fresh to your doorstep. 🏠'
            ], 200);
        }
    }

    public function menu_details_ar(Request $request)
    {
        $menu = [
            'طلب جديد',
            'تتبع الطلب',
            'تحديد أقرب فرع',
            'الدعم الفني',
        ];

        $exist = customerModel::where('customer_mob', $request->cid)->first();
        if ($exist) {
            $latest_cart = ApiCartModel::where('customer_id', $exist->customer_id)
                ->where('checkout_status', '!=', 2)
                ->get();

            $orders = ApiCartModel::where('customer_id', $exist->customer_id)
                ->where('checkout_status', 2)
                ->get();

            $orders_data = orderModel::where('order_customer_id', $exist->customer_id)
                ->whereIn('order_tracking_status', ['Placed', 'Approved'])
                ->get();

            if ($orders_data->count() > 0) {
                array_unshift($menu, 'إلغاء الطلب');
            }

            if ($latest_cart->count() > 0) {
                array_unshift($menu, 'عرض السلة');
            }

            if ($orders->count() > 0) {
                array_unshift($menu, 'الطلبات السابقة');
            }

            return response()->json([
                'status' => true,
                'menus' => $menu,
                'message' => 'نحن متحمسون لتقديم أشهى الوجبات طازجة ومباشرة إلى باب منزلك',
            ], 200);
        } else {
            return response()->json([
                'status' => true,
                'menus' => $menu,
                'message' => 'نحن متحمسون لتقديم أشهى الوجبات طازجة ومباشرة إلى باب منزلك'
            ], 200);
        }
    }

    public function customer_login(Request $request)
    {
        //Log::info('CID ' . json_encode($request->all()));
        $validator = Validator::make($request->all(), [
            //'customer_name' => 'required',
            'customer_mob' => 'required',
        ]);

        if ($validator->fails()) {
            return response()->json([
                'status' => false,
                'message' => 'validation error',
                'errors' => $validator->errors(),
            ], 401);
        }

        $menu = [
            'Place New Order',
            'Track My Order',
            'Locate Nearest Store',
            'Get Support',
        ];

        $exist = customerModel::where('customer_mob', $request->customer_mob)->first();
        if ($exist) {
            $latest_cart = ApiCartModel::with('cart_recipe', 'cart_recipe.recipe', 'cart_recipe.recipe_add_on')
                ->where('customer_id', $exist->customer_id)
                ->where('checkout_status', '!=', 2)
                ->get();

            $orders = ApiCartModel::with('cart_recipe', 'cart_recipe.recipe', 'cart_recipe.recipe_add_on')
                ->where('customer_id', $exist->customer_id)
                ->where('checkout_status', 2)
                ->get();

            if ($latest_cart->count()) {
                array_unshift($menu, 'Show My Cart');
            }

            if ($orders->count()) {
                array_unshift($menu, 'Previous Orders');
            }
            return response()->json([
                'status' => true,
                'message' => '👋 Welcome back, ' . $exist->customer_name . '! Great to see you again at Restaurant! 😄Craving something crispy and delicious? 🍗🍟',
                'token' => $exist->customer_unique_id,
                'menus' => $menu,
            ], 200);
        } else {
            $unique_id = $this->sku_generate();
            $customer = customerModel::create([
                'customer_status' => 0,
                'customer_unique_id' => $unique_id,
                'customer_name' => $request->customer_name ?: $request->customer_mob,
                'customer_mob' => $request->customer_mob,
            ]);

            return response()->json([
                'status' => true,
                'message' => '👋 Welcome to Restaurant! We’re excited to serve you delicious meals 🍔🍟 delivered fresh to your doorstep. 🏠',
                'token' => $unique_id,
                'menus' => $menu,
            ], 200);
        }
    }

    public function show_my_cart(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        //$latest_cart = ApiCartModel::with('cart_recipe', 'cart_recipe.recipe', 'cart_recipe.recipe_add_on')
        $latest_cart = ApiCartModel::with('cart_recipe', 'cart_recipe.recipe', 'cart_recipe.recipe_add_on')
            ->where('customer_id', $customer_id)
            ->where('checkout_status', '!=', 2)
            ->orderBy('id', 'desc')
            ->first();

        if ($latest_cart) {
            $recipe_array = [];
            $api_recipe = ApiCartRecipeModel::where('api_cart_id', $latest_cart->id)->get();
            foreach ($api_recipe as $recipe) {
                $prod = recipeModel::where('recipe_id', $recipe->recipe_id)->first();
                //$add_on = ApiCartRecipeAddOnModel::where('api_cart_recipe_id', $recipe->id)->get();

//                $add_on_array = [];
//                foreach ($add_on as $each) {
//                    $prod2 = recipe_add_on_Model::where('add_on_id', $each->add_on_id)->first();
//                    $add_on_array[] = [
//                        'name' => $prod2->add_on_name,
//                        'price' => $prod2->add_on_price,
//                    ];
//                }

                $recipe_array[] = [
                    'name' => $prod->recipe_name,
                    'quantity' => $recipe->quantity,
                    'price' => $prod->recipe_price,
                    //'add_on_array' => $add_on_array,
                ];
            }
            return response()->json([
                'status' => true,
                'cart_products' => $latest_cart,
                'recipe_array' => $recipe_array,
            ], 200);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'No Cart Found!',
            ], 200);
        }
    }

    public function get_category($menu)
    {
        //if ($menu == 'Place New Order' || $menu == 'طلب جديد') {
        $categories = categoryModel::where('category_status', 0)->get();

        return response()->json([
            'status' => true,
            'categories' => $categories,
        ], 200);
        //}
    }

    public function get_sub_category($id)
    {
//        $sub_categories = subcategoryModel::where('subcategory_cid', $id)->get();
//
//        if ($sub_categories->count()) {
//            return response()->json([
//                'status' => true,
//                'sub_categories' => $sub_categories,
//            ], 200);
//        } else {
        $products = recipeModel::where('recipe_category_id', $id)->get();

        return response()->json([
            'status' => true,
            'products' => $products,
        ], 200);
//        }
    }

    public function get_products_from_sub_category($id)
    {
        $products = recipeModel::where('recipe_subcategory_id', $id)->get();

        if ($products->count()) {
            return response()->json([
                'status' => true,
                'products' => $products,
                'message' => 'Products Found!',
            ], 200);
        } else {
            return response()->json([
                'status' => true,
                'message' => 'Products Not Found!',
            ], 200);
        }
    }

    public function products_details($id)
    {
        //$product = recipeModel::with('recipe_add_on')->where('recipe_id', $id)->first();
        $product = recipeModel::where('recipe_id', $id)->first();

        if ($product) {
//            $addOnsGrouped = DB::table('tbl_recipe_adds_on')
//                ->where('recipe_id', $id)
//                ->select('add_on_group', 'add_on_name', 'add_on_id', 'add_on_price')
//                ->get()
//                ->groupBy('add_on_group')->take(3);
//
//            $group = [];
//            foreach ($product->recipe_add_on as $group2) {
//                $group[] = [
//                    'add_on_name' => $group2->add_on_group,
//                    'free_count' => $group2->free_count,
//                ];
//            }
//
//            $filtered = collect($addOnsGrouped)->map(function ($items) {
//                return collect($items)->take(3)->values();
//            });
//
//            $unique = collect($group)->unique('add_on_name')->take(3)->values();

            return response()->json([
                'status' => true,
                'product' => $product,
                //'add_on_groups' => $unique,
                //'add_on_group_items' => $filtered,
                'product_img' => '/uploads/recipe_images/' . $product->recipe_image,
                'image_url' => $product->image_url,
                'message' => 'Product Found!',
            ], 200);
        } else {
            return response()->json([
                'status' => true,
                'message' => 'Product Not Found!',
            ], 200);
        }
    }

    public function sku_generate()
    {
        $lastcustomer = customerModel::orderby('customer_id', 'DESC')->first();
        if ($lastcustomer) {
            $lastcustomer = $lastcustomer->customer_unique_id;
            $newdata = substr($lastcustomer, -4);
            $newUniq = env('CUSTOMERUNIQID') . sprintf('%04d', ($newdata + 1));
        } else {
            $newUniq = env('CUSTOMERUNIQID') . sprintf('%04d', 1);
        }
        return $newUniq;
    }

    public function get_location(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $latest_cart = ApiCartModel::where('customer_id', $customer_id)->orderBy('id', 'desc')->first();

        if ($latest_cart) {
            $cart_id = $latest_cart->id;
            ApiCartModel::find($cart_id)->update(['latitude' => $request->latitude, 'longitude' => $request->longitude]);

            return response()->json([
                'status' => true,
                'message' => 'Location Updated Successfully',
            ], 200);
        } else {
            return response()->json([
                'status' => true,
                'message' => 'Your Cart is Empty',
            ], 200);
        }
    }

    public function add_to_cart(Request $request)
    {
        //Log::info('add_to_cart ' . $request->cid, $request->item_id, $request->quantity);
        $item_id = $request->item_id;
        $cid = $request->cid;
        $quantity = $request->quantity;

        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $exist = ApiCartModel::where('customer_id', $customer_id)->where('checkout_status', '!=', 2)
            ->orderBy('id', 'desc')->first();

        if ($exist) {
            $exist_recipe = ApiCartRecipeModel::where('api_cart_id', $exist->id)->where('recipe_id', $item_id)->first();
            if ($exist_recipe) {
                ApiCartRecipeModel::where('api_cart_id', $exist->id)->where('recipe_id', $item_id)
                    ->update(['quantity' => $quantity]);
                return response()->json([
                    'cart_id' => $exist->id,
                    'status' => true,
                    'message' => 'Item Updated to Cart Successfully',
                ], 200);
            } else {
                $cart_recipe = ApiCartRecipeModel::create([
                    'api_cart_id' => $exist->id,
                    'recipe_id' => $item_id,
                    'quantity' => $quantity,
                ]);

                if ($cart_recipe) {
                    return response()->json([
                        'cart_id' => $exist->id,
                        'status' => true,
                        'message' => 'Item Added to Cart Successfully',
                    ], 200);
                }
            }
        } else {
            $add_to_cart = ApiCartModel::create([
                'customer_id' => $customer_id,
            ]);

            $cart_recipe = ApiCartRecipeModel::create([
                'api_cart_id' => $add_to_cart->id,
                'recipe_id' => $item_id,
                'quantity' => $quantity,
            ]);

            if ($cart_recipe) {
                return response()->json([
                    'cart_id' => $add_to_cart->id,
                    'status' => true,
                    'message' => 'Item Added to Cart Successfully',
                ], 200);
            }
        }
    }

    public function modify_cart(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $latest_cart = ApiCartModel::where('customer_id', $customer_id)->where('checkout_status', '!=', 2)->orderBy('id', 'desc')->first();
        $cart_id = $latest_cart->id;
        //$cart_products = ApiCartRecipeModel::with('recipe')->where('api_cart_id', $cart_id)->get();

        $latest_cart = ApiCartModel::with('cart_recipe', 'cart_recipe.recipe', 'cart_recipe.recipe_add_on')
            ->where('customer_id', $customer_id)
            ->where('checkout_status', '!=', 2)
            ->orderBy('id', 'desc')
            ->first();

        if ($latest_cart) {
            $recipe_array = [];
            $api_recipe = ApiCartRecipeModel::where('api_cart_id', $latest_cart->id)->get();
            foreach ($api_recipe as $recipe) {
                $prod = recipeModel::where('recipe_id', $recipe->recipe_id)->first();
                $add_on = ApiCartRecipeAddOnModel::where('api_cart_recipe_id', $recipe->id)->get();

                $add_on_array = [];
                foreach ($add_on as $each) {
                    $prod2 = recipe_add_on_Model::where('add_on_id', $each->add_on_id)->first();
                    $add_on_array[] = [
                        'name' => $prod2->add_on_name,
                        'price' => $prod2->add_on_price,
                    ];
                }

                $recipe_array[] = [
                    'name' => $prod->recipe_name,
                    'quantity' => $recipe->quantity,
                    'price' => $prod->recipe_price,
                    'add_on_array' => $add_on_array,
                ];
            }
            return response()->json([
                'status' => true,
                'cart_id' => $cart_id,
                'cart_products' => $latest_cart,
                'recipe_array' => $recipe_array,
            ], 200);
//            return response()->json([
//                'cart_id' => $cart_id,
//                'status' => true,
//                'cart_products' => $cart_products,
//            ], 200);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'No Cart Found!',
            ], 200);
        }
    }

    public function modify_this(Request $request)
    {
        //Log::info('modify_this ' . $request->cid, $request->item_id);
        $cid = $request->cid;
        $item_id = $request->item_id;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $latest_cart = ApiCartModel::where('customer_id', $customer_id)
            ->where('checkout_status', '!=', 2)->orderBy('id', 'desc')->first();
        $cart_id = $latest_cart->id;
        $cart_product = ApiCartRecipeModel::with('recipe')->where('api_cart_id', $cart_id)
            ->where('recipe_id', $item_id)->first();

        return response()->json([
            'cart_id' => $cart_id,
            'status' => true,
            'cart_product' => $cart_product,
        ], 200);
    }

    public function clear_cart(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $latest_cart = ApiCartModel::where('customer_id', $customer_id)->where('checkout_status', '!=', 2)
            ->orderBy('id', 'desc')->get();

        foreach ($latest_cart as $each) {
            $cart_id = $each->id;
            ApiCartModel::where('id', $cart_id)->delete();
            ApiCartRecipeModel::where('api_cart_id', $cart_id)->delete();
        }
        return response()->json([
            //'cart_id' => $cart_id,
            'status' => true,
            'message' => 'Cart Deleted Successfully',
        ], 200);
    }

    public function checkout(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $latest_cart = ApiCartModel::where('customer_id', $customer_id)->where('checkout_status', '!=', 2)->orderBy('id', 'desc')->first();
        $cart_id = $latest_cart->id;

        $cart = ApiCartModel::find($cart_id)->update(['checkout_status' => 1]);
        $cart_data = ApiCartModel::with('cart_recipe', 'cart_recipe.recipe', 'cart_recipe.recipe_add_on', 'cart_recipe.recipe_add_on.add_on_item')->find($cart_id);

        if ($cart) {
            return response()->json([
                'status' => true,
                'cart_data' => $cart_data,
                'message' => 'Checkout Status Updated Successfully',
                'message_ar' => 'Checkout Status Updated Successfully',
            ], 200);
        }
    }

    public function update_quantity(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $latest_cart = ApiCartModel::where('customer_id', $customer_id)->where('checkout_status', '!=', 2)->orderBy('id', 'desc')->first();
        $cart_id = $latest_cart->id;
        $item_id = $request->item_id;
        $quantity = $request->quantity;

        $cart = ApiCartRecipeModel::where('api_cart_id', $cart_id)->where('recipe_id', $item_id)->update(['quantity' => $quantity]);
        $cart_products = ApiCartRecipeModel::with('recipe')->where('api_cart_id', $cart_id)
            ->where('recipe_id', $item_id)->get();

        if ($cart) {
            return response()->json([
                'status' => true,
                'message' => 'Cart Updated Successfully',
                'product2' => $cart_products,
            ], 200);
        }
    }

    public function update_delivery_type(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $latest_cart = ApiCartModel::where('customer_id', $customer_id)
            ->where('checkout_status', '!=', 2)->orderBy('id', 'desc')->first();
        $cart_id = $latest_cart->id;
        $delivery_type = $request->delivery_type;
        //Log::info('CID ' . $request->cid, $request->delivery_type);
        ApiCartModel::find($cart_id)->update(['delivery_type' => $delivery_type]);
        if ($delivery_type == 1) {
            return response()->json([
                'status' => true,
                'branches' => branchModel::all(),
                'message' => 'Delivery Type Updated Successfully',
            ], 200);
        } else {
            return response()->json([
                'status' => true,
                'message' => 'Delivery Type Updated Successfully',
            ], 200);
        }
    }

    public function update_address(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $latest_cart = ApiCartModel::where('customer_id', $customer_id)->where('checkout_status', '!=', 2)->orderBy('id', 'desc')->first();
        $cart_id = $latest_cart->id;
        $address = $request->address ?: NULL;
        $phone_number = $request->phone_number ?: NULL;
        $lattitude = $request->lattitude ?: NULL;
        $longitude = $request->longitude ?: NULL;
        ApiCartModel::find($cart_id)->update([
            'address' => $address,
            'phone_number' => $phone_number,
            'lattitude' => $lattitude,
            'longitude' => $longitude,
        ]);

        return response()->json([
            'status' => true,
            'message' => 'Delivery Address Updated Successfully',
        ], 200);
    }

    public function update_phone_number(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $latest_cart = ApiCartModel::where('customer_id', $customer_id)->where('checkout_status', '!=', 2)->orderBy('id', 'desc')->first();
        $cart_id = $latest_cart->id;
        $phone_number = $request->phone_number;
        ApiCartModel::find($cart_id)->update(['mobile_no' => $phone_number]);

        return response()->json([
            'status' => true,
            'message' => 'Alternative Phone Number Updated Successfully',
        ], 200);
    }

    public function order_unique_id_generator()
    {
        $lastorder = orderModel::orderby('order_id', 'DESC')->first();
        if ($lastorder) {
            $order_unique_id = $lastorder->order_unique_id;
            $newdata = substr($order_unique_id, -6);
            $newUniq = env('ORDERUNIQID') . sprintf('%06d', ($newdata + 1));
        } else {
            $newUniq = env('ORDERUNIQID') . sprintf('%06d', 1);
        }
        return $newUniq;
    }

    public function make_payment(Request $request)
    {
        $cid = $request->cid;
        $customer = customerModel::where('customer_mob', $cid)->first();
        $customer_id = $customer->customer_id;
        $latest_cart = ApiCartModel::where('customer_id', $customer_id)->where('checkout_status', '!=', 2)
            ->orderBy('id', 'desc')->first();
        if ($latest_cart) {
            if ($latest_cart->checkout_status != 2) {
                $cart_id = $latest_cart->id;
                $cart_data = ApiCartModel::find($cart_id);
                $cart_recipe_data = ApiCartRecipeModel::with('recipe_add_on')
                    ->where('api_cart_id', $cart_id)->get();

                $unique_order_id = $this->order_unique_id_generator();
//                try {
//
//                    // Start a database transaction
//                    DB::beginTransaction();
                //Form Inputs
                $order = new orderModel();
                $order->order_status = 0;
                $order->order_ip = $request->ip();
                $order->order_date = date('Y-m-d');
                $order->order_time = date('H:i');
                $order->order_unique_id = $unique_order_id;
                $order->order_customer_id = $cart_data->customer_id;
                $order->order_customer_name = $customer->customer_name;
                $order->order_customer_mob = $customer->customer_mob;
                $order->delivery_type = $latest_cart->delivery_type;
                $order->branch_id = $latest_cart->branch_id;
                $order->order_customer_mail = NUll;
                $order->order_table_id = NUll;
                $order->order_promocode_id = 0;
                $order->order_table_id = 20;
                $order->order_cost = 0;
                $order->order_net_amount = 0;
                $order->order_discount_amt = 0;
                $order->order_profit = 0;
                $order->order_grand_total = 0;
                $order->order_cart_customer_id = $cart_id;
                $order->order_tracking_status = 'Pending';
                $order->save();
                $order_id = $order->id;

                $total_add_on_price = 0;
                $total_amount = 0;
                foreach ($cart_recipe_data as $eachItem) {
                    $recipe = recipeModel::where('recipe_id', $eachItem->recipe_id)->first();
                    $total_amount += $recipe->recipe_price * $eachItem->quantity;

                    $order_item = new orderitemModel();
                    $order_item->order_item_status = 0;
                    $order_item->order_id = $order_id;
                    $order_item->recipe_id = $eachItem->recipe_id;
                    $order_item->order_item_name = $recipe->recipe_name;
                    $order_item->order_item_price = $recipe->recipe_price;
                    $order_item->order_item_quantity = $eachItem->quantity;
                    $order_item->order_item_cost = 0;
                    $order_item->order_item_netamount = $recipe->recipe_price * $eachItem->quantity;
                    $order_item->order_item_discount_amt = 0;
                    $order_item->order_item_profit = 0;
                    $order_item->order_item_grand_total = $recipe->recipe_price * $eachItem->quantity;
                    $order_item->save();

                    if ($eachItem->recipe_add_on) {
                        foreach ($eachItem->recipe_add_on as $eachAddon) {
                            $add_on = recipe_add_on_Model::where('add_on_id', $eachAddon->add_on_id)->first();
                            $addon = new order_item_add_onModel();
                            $addon->order_item_add_on_status = 0;
                            $addon->order_item_id = $order_item->id;
                            $addon->add_on_id = $add_on->add_on_id;
                            $addon->order_item_add_on_name = $add_on->add_on_name;
                            $addon->order_item_add_on_price = $add_on->add_on_price;
                            $addon->order_item_add_on_quantity = $eachItem->quantity;
                            $addon->order_item_add_on_total_price = $add_on->add_on_price * $eachItem->quantity;
                            $addon->order_item_addon_image = NUll;
                            $addon->save();

                            $total_add_on_price = $total_add_on_price + ($add_on->add_on_price * $eachItem->quantity);
                        }
                    }
                }

                $total_paid_amount = $total_amount + $total_add_on_price;

                orderModel::where('order_id', $order_id)
                    ->update(['order_net_amount' => $total_paid_amount,
                        'order_grand_total' => $total_paid_amount]);
                $cart = ApiCartModel::find($cart_id)->update(['checkout_status' => 2]);
                $notification_data = [
                    'notification_type' => 1, //New Order
                    'notification_name' => "New Order Received",
                    'notification_desc' => "New Order " . $unique_order_id . ' has been received by the customer ' . $customer->customer_name,
                    'priviliage' => 1
                ];
                $this->admin_noticication($notification_data);

                $payment_url = 'https://albaitalkuwaiti.dmenus.com/payment/' . $unique_order_id . '/' . $total_paid_amount;
                return response()->json([
                    'status' => true,
                    'order_id' => $unique_order_id,
                    'total_amount' => $total_amount,
                    'payment_link' => $payment_url,
                ], 200);
//
//                } catch (QueryException $e) {
//
//                    DB::rollBack();
//
//                }
            } else {
                return response()->json([
                    'status' => false,
                    'message' => 'Already place this order',
                ], 200);
            }
        } else {
            return response()->json([
                'status' => false,
                'message' => 'No Cart Items',
            ], 200);
        }
    }

    public function admin_noticication($notification_data)
    {
        $notification_data['notification_status'] = 0;
        $notification_data['notification_seen_status'] = 0;
        $notification_data['notification_date'] = date('Y-m-d');
        $notification_data['notification_time'] = date('H:i');
        $notification_data['notification_branch'] = 1;

        $insert_admin_notification = notificationModel::insert($notification_data);
    }

    public function track_my_order(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $order = orderModel::where('order_customer_id', $customer_id)->orderBy('order_id', 'desc')->first();

        if ($order) {
            return response()->json([
                'status' => true,
                'order_status' => $order->order_tracking_status,
            ], 200);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Order Not Found!',
            ], 200);
        }
    }

    public function get_branches()
    {
        $branches = branchModel::all();

        return response()->json([
            'status' => true,
            'branches' => $branches,
        ], 200);
    }

    public function save_add_on_items(Request $request)
    {
        //Log::info('CID ' . $request->cid);
        $cid = $request->cid;
        $item_id = $request->item_id;
        $add_on_id = $request->add_on_id;
        $add_on_quantity = 1;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $cart = ApiCartModel::where('customer_id', $customer_id)->where('checkout_status', '!=', 2)
            ->orderBy('id', 'desc')->first();
        if ($cart) {
            $order_recipe = ApiCartRecipeModel::where('api_cart_id', $cart->id)->where('recipe_id', $item_id)->first();
            ApiCartRecipeAddOnModel::create([
                'api_cart_recipe_id' => $order_recipe->id,
                'add_on_id' => $add_on_id,
                'add_on_quantity' => $order_recipe->quantity,
            ]);

            return response()->json([
                'status' => true,
                'message' => 'Add on added successfully',
            ], 200);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Cart Not Found!',
            ], 200);
        }
    }

    public function delete_product_form_cart(Request $request)
    {
        $cid = $request->cid;
        $item_id = $request->item_id;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $cart = ApiCartModel::where('customer_id', $customer_id)->where('checkout_status', '!=', 2)->orderBy('id', 'desc')->first();
        if ($cart) {
            $api_cart_recipe = ApiCartRecipeModel::where('api_cart_id', $cart->id)->where('recipe_id', $item_id);
            $cart_recipe = $api_cart_recipe->first();
            if ($cart_recipe) {
                $api_cart_recipe_id = $cart_recipe->id;
                ApiCartRecipeModel::where('id', $api_cart_recipe_id)->where('recipe_id', $item_id)->delete();
                ApiCartRecipeAddOnModel::where('api_cart_recipe_id', $api_cart_recipe_id)->delete();

                return response()->json([
                    'status' => true,
                    'message' => 'Cart Item Deleted Successfully',
                ], 200);
            } else {
                return response()->json([
                    'status' => false,
                    'message' => 'Product Not Found!',
                ], 200);
            }
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Your Cart is Empty!',
            ], 200);
        }
    }

    public function get_address(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $cart = ApiCartModel::where('customer_id', $customer_id)->where('checkout_status', 2)
            ->orderBy('id', 'desc')->first();

        if ($cart) {
            return response()->json([
                'status' => true,
                'address' => $cart->address,
                'phone_number' => $cart->phone_number,
            ], 200);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Not Found!',
            ], 200);
        }
    }

    public function save_note(Request $request)
    {
        $cid = $request->cid;
        $note = $request->note;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $cart = ApiCartModel::where('customer_id', $customer_id)->where('checkout_status', 1)
            ->orderBy('id', 'desc')->update(['note' => $note]);

        if ($cart) {
            return response()->json([
                'status' => true,
                'message' => 'Note Updated Successfully',
            ], 200);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Not Found!',
            ], 200);
        }
    }

    public function previous_orders(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $cart = ApiCartModel::with('order', 'order.order_items', 'order.order_items.order_item_add_on')
            ->where('customer_id', $customer_id)->where('checkout_status', 2)->get();

        if ($cart) {
            return response()->json([
                'status' => true,
                'cart' => $cart,
            ], 200);
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Not Found!',
            ], 200);
        }
    }

    public function cancel_order(Request $request)
    {
//        $response = Http::attach(
//            'image', // form field name
//            file_get_contents(asset('/uploads/recipe_images/20230706122014.png')),
//            '20230706122014.png'
//        )->post('https://superchatbot.gingerconsultancyservices.in/upload-image');
//
//        return response()->json([
//            'status' => true,
//            'cart' => $response->body(),
//        ], 200);
//        $imagePath = asset('/uploads/recipe_images/');
//        $imageName = '20230706122014.png';

//        $curl = curl_init();
//
//        curl_setopt_array($curl, [
//            CURLOPT_URL => 'https://superchatbot.gingerconsultancyservices.in/upload-image',
//            CURLOPT_RETURNTRANSFER => true,
//            CURLOPT_POST => true,
//            CURLOPT_VERBOSE => true,
//            CURLOPT_POSTFIELDS => [
//                'image' => new CURLFile($imagePath, mime_content_type($imagePath), $imageName),
//            ],
//        ]);
//
//        $response = curl_exec($curl);
//        $err = curl_error($curl);
//        curl_close($curl);

//        $curl = curl_init();
//
//        $postFields = [
//            'file' => new CURLFile($imagePath, mime_content_type($imagePath), $imageName),
//            'number_id' => '298596140007872',
//            'wa_id' => '304589052739786',
//            'access_token' => 'EAASqMLEfZAh0BOz1nDXcNxQHtyuJigDQQsZCpFmPZ...' // your actual token
//        ];
//
//        curl_setopt_array($curl, [
//            CURLOPT_URL => 'https://superchatbot.gingerconsultancyservices.in/upload-image',
//            CURLOPT_RETURNTRANSFER => true,
//            CURLOPT_POST => true,
//            CURLOPT_POSTFIELDS => $postFields,
//            CURLOPT_HTTPHEADER => [
//                'Accept: application/json',
//            ],
//        ]);
//
//        $response = curl_exec($curl);
//        $error = curl_error($curl);
//        curl_close($curl);
//
//        return response()->json([
//            'status' => true,
//            'cart' => $response,
//        ], 200);
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $cart = ApiCartModel::where('customer_id', $customer_id)
            ->where('checkout_status', 2)
            ->orderBy('id', 'desc')->first();
        if ($cart) {
            $order_tracking_status = orderModel::where('order_cart_customer_id', $cart->id)->first()->order_tracking_status;

            if ($order_tracking_status == 'Placed' || $order_tracking_status == 'Approved') {
                orderModel::where('order_cart_customer_id', $cart->id)
                    ->update(['order_tracking_status' => 'Cancelled']);

                return response()->json([
                    'status' => true,
                    'message' => 'Order Cancelled',
                ], 200);
            } else {
                return response()->json([
                    'status' => true,
                    'message' => 'Order can not cancelled this time. The current order status is ' . $order_tracking_status
                ], 200);
            }
        } else {
            return response()->json([
                'status' => false,
                'message' => 'Order Not Found!',
            ], 200);
        }
    }

    public function faq(Request $request)
    {
        $cid = $request->cid;
        $faq = $request->faq;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;

        TalkToAgent::create([
            'customer_id' => $customer_id,
            'faq' => $faq
        ]);

        return response()->json([
            'status' => false,
            'message' => 'Talk To Agent Successfully!',
        ], 200);
    }

    public function order_again(Request $request)
    {
        $cart_id = $request->cart_id;
        $old_cart = ApiCartModel::find($cart_id);
        $new_cart_id = ApiCartModel::create([
            'customer_id' => $old_cart->customer_id,
            'lattitude' => $old_cart->lattitude,
            'longitude' => $old_cart->longitude,
            'address' => $old_cart->address,
            'phone_number' => $old_cart->phone_number,
            'delivery_type' => $old_cart->delivery_type,
            'note' => $old_cart->note,
            'checkout_status' => 1,
        ]);

        $old_cart_recipes = ApiCartRecipeModel::where('api_cart_id', $cart_id)->get();
        foreach ($old_cart_recipes as $each) {
            $cart_recipes = ApiCartRecipeModel::create([
                'api_cart_id' => $new_cart_id->id,
                'recipe_id' => $each->recipe_id,
                'quantity' => $each->quantity,
            ]);

            $cart_recipe_add_on = ApiCartRecipeAddOnModel::where('api_cart_recipe_id', $each->id)->get();
            foreach ($cart_recipe_add_on as $add_on) {
                ApiCartRecipeAddOnModel::create([
                    'api_cart_recipe_id' => $cart_recipes->id,
                    'add_on_id' => $add_on->add_on_id,
                    'add_on_quantity' => $add_on->add_on_quantity,
                ]);
            }
        }

        $cart_data = ApiCartModel::with('cart_recipe', 'cart_recipe.recipe', 'cart_recipe.recipe_add_on', 'cart_recipe.recipe_add_on.add_on_item')->find($new_cart_id->id);

        return response()->json([
            'status' => true,
            'cart_data' => $cart_data,
            'message' => 'Product Added Cart Successfully',
        ], 200);
    }

    public function talk_to_agent(Request $request)
    {
        $cid = $request->cid;
        //$faq = $request->faq;
        $customer = customerModel::where('customer_mob', $cid)->first();
        $customer_id = $customer->customer_id;

        TalkToAgent::create([
            'customer_id' => $customer_id,
            //'faq' => $faq
        ]);

        $notification_data = [
            'notification_type' => 2, //Talk To Agent
            'notification_name' => "New Talk To Agent",
            'notification_desc' => 'New notification has been received by the customer ' . $customer->customer_name,
            'priviliage' => 1
        ];
        $this->admin_noticication($notification_data);

        return response()->json([
            'status' => false,
            'message' => 'Talk To Agent Successfully!',
        ], 200);
    }

    public function get_faq()
    {
        $faqs = Faq::all();

        return response()->json([
            'status' => false,
            'faqs' => $faqs,
        ], 200);
    }

    public function update_branch(Request $request)
    {
        $cid = $request->cid;
        $branch_id = $request->branch_id;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $latest_cart = ApiCartModel::where('customer_id', $customer_id)
            ->where('checkout_status', '!=', 2)->orderBy('id', 'desc')->first();
        $cart_id = $latest_cart->id;
        ApiCartModel::find($cart_id)->update(['branch_id' => $branch_id]);

        return response()->json([
            'status' => true,
            'branches' => branchModel::all(),
            'message' => 'Delivery Type Updated Successfully',
        ], 200);
    }

    public function previous_address(Request $request)
    {
        $cid = $request->cid;
        $customer_id = customerModel::where('customer_mob', $cid)->first()->customer_id;
        $latest_cart = ApiCartModel::where('customer_id', $customer_id)
            ->where('checkout_status', 2)->orderBy('id', 'desc')->first();

        if ($latest_cart) {
            if ($latest_cart->address) {
                return response()->json([
                    'status' => true,
                    'address' => $latest_cart->address,
                    'phone' => $latest_cart->phone_number,
                ], 200);
            } else {
                return response()->json([
                    'status' => true,
                    'message' => 'Address not found!',
                ], 200);
            }
        } else {
            return response()->json([
                'status' => true,
                'message' => 'Cart not found!',
            ], 200);
        }
    }

    public function payment_response(Request $request)
    {
        Log::info($request);
        if ($request['id']) {
            $transaction = Transaction::create([
                'payment_id' => $request['id'],
                //'transaction_id' => $request['trans_id'],
                'order_id' => $request['transId'],
                'hash' => $request['hash'],
                'status' => $request['statusId'],
            ]);

            if ($transaction) {
                


                if ($transaction->status == 2 && $request['status'] == 'Paid') {
                    
                    orderModel::where('order_unique_id', $request['transId'])
                    ->update(['transaction_id' => $transaction->id, 'order_tracking_status' => 'Placed']);
                    
                    $item_name_array = NULL;
                    $quantity_array = NULL;
                    $order_item_quantity_array = NULL;
                    $item_id_array = NULL;
                    $item_varient_id_array = NULL;
                    $item_price_array = NULL;
                    $item_total_price_array = NULL;
                    $item_org_price_array = NULL;
                    $item_org_total_price_array = NULL;
                    $item_type_array = NULL;
                    $sub_total = 0;
                    $grand_amount = 0;
                    $payment_type = 'Cash';
                    $order = orderModel::where('order_unique_id', $request['transId'])->first();
                    $order_id = $order->order_id;
                    $customer_id = $order->order_customer_id;
                    $customer_name = $order->order_customer_name;
                    $customer_mob = $order->order_customer_mob;
                    $order_items = orderitemModel::where('order_id', $order_id)->get();
                    foreach ($order_items as $each_item) {
                        $item_name_array[] = $each_item->order_item_name;
                        $quantity_array[] = $each_item->order_item_quantity;
                        $order_item_quantity_array[] = $each_item->order_item_quantity;
                        $item_id_array[] = $each_item->recipe_id;
                        $item_varient_id_array[] = 1;
                        $item_price_array[] = $each_item->order_item_price;
                        $item_total_price_array[] = $each_item->order_item_price * $each_item->order_item_quantity;
                        $item_org_price_array[] = $each_item->order_item_price;
                        $item_org_total_price_array[] = $each_item->order_item_price * $each_item->order_item_quantity;
                        $item_type_array[] = 'recipe';
                        $sub_total += $each_item->order_item_price * $each_item->order_item_quantity;
                        $grand_amount += $each_item->order_item_price * $each_item->order_item_quantity;
                        $order_items_add_ons = order_item_add_onModel::where('order_item_id', $each_item->order_item_id)->get();
                        foreach ($order_items_add_ons as $each_order_items_add_on) {
                            $item_name_array[] = $each_order_items_add_on->order_item_add_on_name;
                            $quantity_array[] = $each_order_items_add_on->order_item_add_on_quantity;
                            $order_item_quantity_array[] = $each_order_items_add_on->order_item_add_on_quantity;
                            $item_id_array[] = $each_order_items_add_on->add_on_id;
                            $item_varient_id_array[] = 1;
                            $item_price_array[] = $each_order_items_add_on->order_item_add_on_price;
                            $item_total_price_array[] = $each_order_items_add_on->order_item_add_on_price * $each_order_items_add_on->order_item_add_on_quantity;
                            $item_org_price_array[] = $each_order_items_add_on->order_item_add_on_price;
                            $item_org_total_price_array[] = $each_order_items_add_on->order_item_add_on_price * $each_order_items_add_on->order_item_add_on_quantity;
                            $item_type_array[] = 'add_on';
                            $sub_total += $each_order_items_add_on->order_item_add_on_price * $each_order_items_add_on->order_item_add_on_quantity;
                            $grand_amount += $each_order_items_add_on->order_item_add_on_price * $each_order_items_add_on->order_item_add_on_quantity;
                        }
                    }

                    $cart_data = ApiCartModel::where('id', $order->order_cart_customer_id)->first();
                    $data = [
                        'order_id' => $order_id,
                        'customer_id' => $customer_id,
                        'customer_name' => $customer_name,
                        'customer_mob' => $customer_mob,
                        'item_name_array' => $item_name_array,
                        'quantity_array' => $quantity_array,
                        'order_item_quantity_array' => $order_item_quantity_array,
                        'item_id_array' => $item_id_array,
                        'item_varient_id_array' => $item_varient_id_array,
                        'item_price_array' => $item_price_array,
                        'item_total_price_array' => $item_total_price_array,
                        'item_org_price_array' => $item_org_price_array,
                        'item_org_total_price_array' => $item_org_total_price_array,
                        'item_type_array' => $item_type_array,
                        'sub_total' => $sub_total,
                        'grand_amount' => $grand_amount,
                        'payment_type' => $payment_type,
                        'delivery_type' => $cart_data->delivery_type ?: 0,
                        'branch_id' => $cart_data->branch_id ?: NULL,
                    ];

                    $this->create_invoice($data);
                    return view('website.payment-success');

                } else {
                    
                    orderModel::where('order_unique_id', $request['transId'])
                    ->update(['transaction_id' => $transaction->id, 'order_tracking_status' => 'Failed']);
                    
                    $order = orderModel::where('order_unique_id', $request['transId'])->first();
                    $order_id = $order->order_id;
                    $customer_id = $order->order_customer_id;
                    $customer_name = $order->order_customer_name;
                    $customer_mob = $order->order_customer_mob;
                    $res = [
                        'wa_id' => $customer_mob,
                        'status' => 'failure',
                        'message' => 'Your payment filed. Please check your payment details and try again',
                        'cid' => $customer_id,
                        'invoice' => '',
                        'invoice_url' => '',
                        'payment_link' => 'https://albaitalkuwaiti.dmenus.com/payments/retry?order=' . $request['transId'],
                    ];

                    $this->send_payment_status($res);
                    
                    return view('website.payment-fail');
                }
            }

            // return view('website.payment-success');
        } else {
            orderModel::where('order_unique_id', $request['transId'])
                    ->update(['transaction_id' => $transaction->id, 'order_tracking_status' => 'Failed']);
                    
            $order = orderModel::where('order_unique_id', $request['order_id'])->first();
            $order_id = $order->order_id;
            $customer_id = $order->order_customer_id;
            $customer_name = $order->order_customer_name;
            $customer_mob = $order->order_customer_mob;
            $res = [
                'wa_id' => $customer_mob,
                'status' => 'failure',
                'message' => 'Your payment failed. Please check your payment details and try again',
                'cid' => $customer_id,
                'invoice' => '',
                'invoice_url' => '',
                'payment_link' => 'https://albaitalkuwaiti.dmenus.com/payments/retry?order=' . $request['trans_id'],
            ];

            $this->send_payment_status($res);
            return view('website.payment-fail');
        }
    }

    public function payment_success(Request $request)
    {
        if ($request['payment_id'] && $request['trans_id']) {
            $transaction = Transaction::create([
                'payment_id' => $request['payment_id'],
                'transaction_id' => $request['trans_id'],
                'order_id' => $request['order_id'],
                'hash' => $request['hash'],
                'status' => 1,
            ]);

            if ($transaction) {
                orderModel::where('order_unique_id', $request['order_id'])
                    ->update(['transaction_id' => $transaction->id, 'order_tracking_status' => 'Placed']);

                //if ($transaction->status == 2 && $request['status'] == 'Paid') {
                $item_name_array = NULL;
                $quantity_array = NULL;
                $order_item_quantity_array = NULL;
                $item_id_array = NULL;
                $item_varient_id_array = NULL;
                $item_price_array = NULL;
                $item_total_price_array = NULL;
                $item_org_price_array = NULL;
                $item_org_total_price_array = NULL;
                $item_type_array = NULL;
                $sub_total = 0;
                $grand_amount = 0;
                $payment_type = 'Cash';
                $order = orderModel::where('order_unique_id', $request['order_id'])->first();
                $order_id = $order->order_id;
                $customer_id = $order->order_customer_id;
                $customer_name = $order->order_customer_name;
                $customer_mob = $order->order_customer_mob;
                $order_items = orderitemModel::where('order_id', $order_id)->get();
                foreach ($order_items as $each_item) {
                    $item_name_array[] = $each_item->order_item_name;
                    $quantity_array[] = $each_item->order_item_quantity;
                    $order_item_quantity_array[] = $each_item->order_item_quantity;
                    $item_id_array[] = $each_item->recipe_id;
                    $item_varient_id_array[] = 1;
                    $item_price_array[] = $each_item->order_item_price;
                    $item_total_price_array[] = $each_item->order_item_price * $each_item->order_item_quantity;
                    $item_org_price_array[] = $each_item->order_item_price;
                    $item_org_total_price_array[] = $each_item->order_item_price * $each_item->order_item_quantity;
                    $item_type_array[] = 'recipe';
                    $sub_total += $each_item->order_item_price * $each_item->order_item_quantity;
                    $grand_amount += $each_item->order_item_price * $each_item->order_item_quantity;
                    $order_items_add_ons = order_item_add_onModel::where('order_item_id', $each_item->order_item_id)->get();
                    foreach ($order_items_add_ons as $each_order_items_add_on) {
                        $item_name_array[] = $each_order_items_add_on->order_item_add_on_name;
                        $quantity_array[] = $each_order_items_add_on->order_item_add_on_quantity;
                        $order_item_quantity_array[] = $each_order_items_add_on->order_item_add_on_quantity;
                        $item_id_array[] = $each_order_items_add_on->add_on_id;
                        $item_varient_id_array[] = 1;
                        $item_price_array[] = $each_order_items_add_on->order_item_add_on_price;
                        $item_total_price_array[] = $each_order_items_add_on->order_item_add_on_price * $each_order_items_add_on->order_item_add_on_quantity;
                        $item_org_price_array[] = $each_order_items_add_on->order_item_add_on_price;
                        $item_org_total_price_array[] = $each_order_items_add_on->order_item_add_on_price * $each_order_items_add_on->order_item_add_on_quantity;
                        $item_type_array[] = 'add_on';
                        $sub_total += $each_order_items_add_on->order_item_add_on_price * $each_order_items_add_on->order_item_add_on_quantity;
                        $grand_amount += $each_order_items_add_on->order_item_add_on_price * $each_order_items_add_on->order_item_add_on_quantity;
                    }
                }

                $data = [
                    'order_id' => $order_id,
                    'customer_id' => $customer_id,
                    'customer_name' => $customer_name,
                    'customer_mob' => $customer_mob,
                    'item_name_array' => $item_name_array,
                    'quantity_array' => $quantity_array,
                    'order_item_quantity_array' => $order_item_quantity_array,
                    'item_id_array' => $item_id_array,
                    'item_varient_id_array' => $item_varient_id_array,
                    'item_price_array' => $item_price_array,
                    'item_total_price_array' => $item_total_price_array,
                    'item_org_price_array' => $item_org_price_array,
                    'item_org_total_price_array' => $item_org_total_price_array,
                    'item_type_array' => $item_type_array,
                    'sub_total' => $sub_total,
                    'grand_amount' => $grand_amount,
                    'payment_type' => $payment_type,
                ];

                $this->create_invoice($data);


//            } else {
//                $order = orderModel::where('order_unique_id', $request['transId'])->first();
//                $order_id = $order->order_id;
//                $customer_id = $order->order_customer_id;
//                $customer_name = $order->order_customer_name;
//                $customer_mob = $order->order_customer_mob;
//                $res = [
//                    'wa_id' => $customer_mob,
//                    'status' => 'failure',
//                    'message' => 'Your payment could not be processed due to insufficient funds.',
//                    'cid' => $customer_id,
//                    'invoice' => '',
//                    'invoice_url' => '',
//                    'payment_link' => 'https://albaitalkuwaiti.dmenus.com/payments/retry?order=' . $request['transId'],
//                ];
//
//                $this->send_payment_status($res);
//            }
            }

            return view('website.payment-success');
        } else {
            $order = orderModel::where('order_unique_id', $request['order_id'])->first();
            $order_id = $order->order_id;
            $customer_id = $order->order_customer_id;
            $customer_name = $order->order_customer_name;
            $customer_mob = $order->order_customer_mob;
            $res = [
                'wa_id' => $customer_mob,
                'status' => 'failure',
                'message' => 'Your payment failed. Please check your payment details and try again',
                'cid' => $customer_id,
                'invoice' => '',
                'invoice_url' => '',
                'payment_link' => 'https://albaitalkuwaiti.dmenus.com/payments/retry?order=' . $request['trans_id'],
            ];

            $this->send_payment_status($res);
        }
    }

    public function payment_failed(Request $request)
    {
        $transaction = Transaction::create([
            'payment_id' => $request['payment_id'],
            'transaction_id' => $request['trans_id'],
            'order_id' => $request['order_id'],
            'hash' => $request['hash'],
            'status' => 0,
        ]);

        if ($transaction) {
            orderModel::where('order_unique_id', $request['order_id'])
                ->update(['transaction_id' => $transaction->id, 'order_tracking_status' => 'Failed']);

            $order = orderModel::where('order_unique_id', $request['order_id'])->first();
            $order_id = $order->order_id;
            $customer_id = $order->order_customer_id;
            $customer_name = $order->order_customer_name;
            $customer_mob = $order->order_customer_mob;
            $res = [
                'wa_id' => $customer_mob,
                'status' => 'failure',
                'message' => 'Your payment failed. Please check your payment details and try again',
                'cid' => $customer_id,
                'invoice' => '',
                'invoice_url' => '',
                'payment_link' => 'https://albaitalkuwaiti.dmenus.com/payments/retry?order=' . $request['trans_id'],
            ];

            $this->send_payment_status($res);
        }
    }

    public function create_invoice($data)
    {
        $order_id = $data['order_id'];
        $customer_id = $data['customer_id'];
        $sub_total = $data['sub_total'];
        $payment_type = $data['payment_type'];
        $grand_amount = $data['grand_amount'];

        $exist = inventoryModel::where('invoice_order_id', $order_id)->first();
        if (!$exist) {
            //Item Details
            $item_name_array = $data['item_name_array'];
            $quantity_array = $data['quantity_array'];
            $order_item_quantity_array = $data['order_item_quantity_array'];
            $item_id_array = $data['item_id_array'];
            $item_varient_id_array = $data['item_varient_id_array'];
            $item_price_array = $data['item_price_array'];
            $item_total_price_array = $data['item_total_price_array'];
            $item_org_price_array = $data['item_org_price_array'];
            $item_org_total_price_array = $data['item_org_total_price_array'];
            $item_type_array = $data['item_type_array'];


            //End Of Item Details


            //Fetch Order Details
            $order_unique_id = "";
            if ($order_id) {
                $order_details = orderModel::where('order_id', $order_id)
                    ->with('order_items.order_item_add_on', 'order_items.order_item_varient', 'table', 'promocode')->first();
                $order_unique_id = $order_details->order_unique_id;
                //Set To Order Status Invoiced
                //$update_prder_status = orderModel::where('order_id', $order_id)->update(['order_tracking_status' => 'Invoiced']);
                //Set The Table To Available
                $table_id = $order_details->order_table_id;
                $update_table = tableModel::where('table_id', $table_id)->update(['table_tracking_status' => 'Available']);

            } else {
                $order_id = 0;
            }

            //fetch Customer_Details
            $customer_name = $customer_mob = "";
            if ($customer_id) {
                $customer_name = $data['customer_name'];
                $customer_mob = $data['customer_mob'];
            }

            //Inventory Table
            $inventory = new inventoryModel();
            $inventory->invoice_status = 0;
            $inventory->invoice_order_id = $order_id;
            $inventory->invoice_orders_unique_id = $order_unique_id;
            $inventory->invoice_date = date('Y-m-d');
            $inventory->invoice_time = date('H:i');
            $inventory->inventory_unique_id = $this->inventoryuniqueIdGenerator();
            $inventory->invoice_payment_type = $payment_type;
            $inventory->invoice_customer_id = $customer_id;
            $inventory->invoice_customer_name = $customer_name;
            $inventory->invoice_contact_number = $customer_mob;
            $inventory->invoice_sub_total = $sub_total;
            $inventory->invoice_discount_amount = 0;
            $inventory->invoice_shipping_charge = 0;
            $inventory->invoice_grand_total = $grand_amount;
            $inventory->invoice_cost = 0;
            $inventory->invoice_profit = 0;
            $inventory->invoice_added_by = 1;
            $inventory->invoice_promocode_id = 0;
            $inventory->delivery_type = $data['delivery_type'];
            $inventory->branch_id = $data['branch_id'];
            $inventory->save();
            $inventory_id = $inventory->id;
            $inventory_unique_id = $inventory->inventory_unique_id;

            //End Of Inventory Table

            //Inventory Item Table


            for ($i = 0; $i < count($item_id_array); $i++) {


                $item_id = $item_id_array[$i];
                $item_name = $item_name_array[$i];
                $item_quantity = $quantity_array[$i];
                $item_varient_id = $item_varient_id_array[$i];
                $item_price = $item_price_array[$i];
                $item_total_price = $item_total_price_array[$i];
                $item_org_price = $item_org_price_array[$i];
                $item_type = $item_type_array[$i];
                $order_item_quantity = $order_item_quantity_array[$i];

                //Item Discount Amount Calculation
                //$item_discount_amount = ($item_price * $discount_percentage) / 100;
                //$item_total_discount_amount = $item_discount_amount * $item_quantity;
                $item_total_discount_amount = 0;
                //End Of Item Amount calculation

                if ($item_type == "recipe") {
                    $item_type_id = 1;
                } else {
                    $item_type_id = 2;
                }  //Set To Value in item Type

                $inventoryitem = new inventoryitemModel();
                $inventoryitem->item_status = 0;
                $inventoryitem->inventory_id = $inventory_id;
                $inventoryitem->inventory_product_name = $item_name;
                $inventoryitem->inventory_item_id = $item_id;
                $inventoryitem->inventory_item_type = $item_type_id;
                $inventoryitem->inventory_item_varient = $item_varient_id;
                $inventoryitem->inventory_item_price = $item_price;
                $inventoryitem->inventory_item_mrp = $item_org_price;
                $inventoryitem->inventory_item_quantity = $item_quantity;
                $inventoryitem->inventory_item_total = $item_total_price;
                $inventoryitem->inventory_item_cost = 0;
                $inventoryitem->item_discount_amount = $item_total_discount_amount;
                $inventoryitem->inventory_item_total_price = $item_total_price - $item_total_discount_amount;
                $inventoryitem->inventory_item_profit = 0;
                $inventoryitem->added_by = 1;
                $inventoryitem->updated_by = 1;
                $inventoryitem->save();

                //If is is a not Order
                if ($order_id == "" || $order_id == 0) {
                    if ($item_type_id == 1) {

                        // update stock and Stock Log
                        $recipe_id = $item_id;
                        $recipe_details = recipeModel::where('recipe_id', $recipe_id)->first();
                        $recipe_name = $recipe_details->recipe_name;
                        $stock_in_or_out = 0;
                        $stock_current_qty = $recipe_details->recipe_stock;
                        $stock_changing_qty = $item_quantity;
                        $stock_updated_qty = $stock_current_qty - $stock_changing_qty;
                        $comment = 'From the Invoice  ' . $inventory->inventory_unique_id . ' ' . $recipe_name . ' stock has been reduced ';

                        stock_and_stock_log($recipe_name, $recipe_id, $stock_in_or_out, $stock_current_qty, $stock_changing_qty, $stock_updated_qty, $comment);
                        // End Of Update Stock And Stock Log

                    }

                }
                //Pos Not From A Order
                //Its From A Order
                else {
                    if ($item_type_id == 1) {
                        $stock_diff = $item_quantity - $order_item_quantity;

                        if ($stock_diff != 0) {  //From an order and quantity Changes

                            if ($stock_diff < 0) {  //If Item Qty Reduce Than Order Qty

                                //Update Stock And Stock Log
                                $recipe_id = $item_id;
                                $recipe_details = recipeModel::where('recipe_id', $recipe_id)->first();
                                $recipe_name = $recipe_details->recipe_name;
                                $stock_in_or_out = 1;
                                $stock_changing_qty = abs($stock_diff);
                                $comment = 'From the Order   #' . $order_unique_id . ' Editing ' . $recipe_name . ' stock has been updated ';

                                $stock_current_qty = $recipe_details->recipe_stock;

                                $stock_updated_qty = $stock_current_qty + $stock_changing_qty;
                                $comment = 'From the Invoice   #' . $inventory->inventory_unique_id . '  Editing ' . $recipe_name . ' stock has been reduced ';

                                stock_and_stock_log($recipe_name, $recipe_id, $stock_in_or_out, $stock_current_qty, $stock_changing_qty, $stock_updated_qty, $comment);

                                // End Of Update Stock And Stock Log


                            } else if ($stock_diff > 0) {//item Qty Greater Than Order Qty
                                //Update Stock And Stock Log
                                $recipe_id = $item_id;
                                $recipe_details = recipeModel::where('recipe_id', $recipe_id)->first();
                                $recipe_name = $recipe_details->recipe_name;

                                $stock_in_or_out = 0;
                                $stock_changing_qty = abs($stock_diff);
                                $comment = 'From the Invoice   #' . $inventory->inventory_unique_id . ' ' . $recipe_name . ' stock has been Reduced ';


                                $stock_current_qty = $recipe_details->recipe_stock;

                                $stock_updated_qty = $stock_current_qty - $stock_changing_qty;
                                $comment = 'From the Invoice  ' . $inventory->inventory_unique_id . ' ' . $recipe_name . ' stock has been reduced ';

                                stock_and_stock_log($recipe_name, $recipe_id, $stock_in_or_out, $stock_current_qty, $stock_changing_qty, $stock_updated_qty, $comment);

                                // End Of Update Stock And Stock Log

                            }


                        }
                    }
                    //End Of Item From a Order

                }
            }

            $data['inventory_data'] = inventoryModel::with('inventory_items', 'inventory_items.recipies', 'inventory_items.varient', 'promocode')
                ->where('invoice_id', $inventory_id)->first();
            $imagePath = public_path('uploads/layouts/202308141341121051.png');
            $imageData = base64_encode(file_get_contents($imagePath));
            $mimeType = mime_content_type($imagePath);
            $base64Image = 'data:' . $mimeType . ';base64,' . $imageData;
            $data['image'] = $base64Image;

            // Load view
            $pdf = PDF::loadView('admin.inventory.pdf', $data);

            // Save PDF to public folder or storage
            //$fileName = 'INV-' . time() . '.pdf';
            $fileName = $inventory_unique_id . '-' . date('y-m-d') . '.pdf';
            $savePath = public_path('invoices/' . $fileName);

            // Ensure folder exists
            if (!file_exists(public_path('invoices'))) {
                mkdir(public_path('invoices'), 0777, true);
            }

            $pdf->save($savePath); // Save to folder

            $response = [
                'wa_id' => $customer_mob,
                'status' => 'success',
                'message' => 'Payment confirmed successfully',
                'cid' => $customer_id,
                'invoice' => $inventory_unique_id,
                'invoice_url' => env('APP_URL') . '/invoices/' . $fileName,
                'payment_link' => '',
            ];

            $this->send_payment_status($response);
        }
    }

    public function inventoryuniqueIdGenerator()
    {
        $lastInv = inventoryModel::orderby('invoice_id', 'DESC')->first();
        if ($lastInv) {
            $inv_unique_id = $lastInv->inventory_unique_id;
            $newdata = substr($inv_unique_id, -6);
            $newUniq = env('INVUNIQID') . sprintf('%06d', ($newdata + 1));
        } else {
            $newUniq = env('INVUNIQID') . sprintf('%06d', 1);
        }
        return $newUniq;
    }

    public function send_payment_status($response)
    {
        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://superchatbot.gingerconsultancyservices.in/send-payment-status',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => json_encode($response),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response2 = curl_exec($curl);

        curl_close($curl);
        //echo $response2;

    }

    public function send_feedback()
    {
        $curl = curl_init();

        $para = [
            'cid' => '12345',
            'message' => 'Hope you enjoyed the food',
        ];

        curl_setopt_array($curl, array(
            CURLOPT_URL => 'https://superchatbot.gingerconsultancyservices.in/send-feedback',
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'POST',
            CURLOPT_POSTFIELDS => http_build_query($para),
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        echo $response;
    }

}
