<?php

namespace App\Exports;

use Illuminate\Support\Facades\DB;
use App\Models\orderModel;
use App\Models\orderitemmodel;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Events\BeforeExport;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithStyles;


class monthwisesaleExport implements FromArray,ShouldAutoSize, WithEvents,WithStyles {


    public function  __construct($data)
    {
    
        $this->data= $data;
      

    }

    private $shouldBeRedNum = [1,2,3,4,5,6,7,8,9,10,11];


    public function array(): array
    {
   //Filter Data Section
    $from_data=$to_data="";
      
    if(session('from_date') && session('to_date')){
        if(session('from_date')){
            $from_data="From Date : ".session('from_date');
        }
        if(session('to_date')){
            $to_data="To Date : ".session('to_date');
        }
    }
    else if(session('from_date')){
        $from_data="Date  : ".session('from_date');
    }

    //End Of Filter Data Section


    //Daily Report Starting


    $top_heading = [
        'Monthly Sale Report',
      ];

    $date_filter_data=['',$from_data,'',$to_data];
      $heading = [
        '#',
        'Month',
        'No.of cash payment',
        'No.of card payment',
        'No.of cash&card payment',
        'Total count',
        'Cash amount',
        'Card amount',
        'Cash and card amount',
        'Total amount',
      ];

   


    
 
    $propertyArray = [];
    $columns[0]=$top_heading;
    $columns[1]=$date_filter_data;
    $columns[2]=$heading;

    $data=$this->data['data'];
    $j=3;
    for($i=0;$i<count($data);$i++){


      // dd($data[$i]);

      $invoice_month=$data[$i]['month_name'].' - ' .$data[$i]['year'];
      $cash_count=$data[$i]['cash_count'];
      $card_count=$data[$i]['card_count'];
      $cash_and_card_count=$data[$i]['cash_and_card_count'];
      $total_invoice_count=$data[$i]['total_invoice_count'];
      $cash_total=$data[$i]['cash_total'];
      $card_total=$data[$i]['card_total'];
      $cash_and_card_total=$data[$i]['cash_and_card_total'];
      $total=$data[$i]['total'];
      
      if($cash_count==null){
        $cash_count="0";
      }
      if($card_count==null || $card_count==""){
        $card_count="0";
      }



      if($cash_and_card_count==null){
        $cash_and_card_count="0";
      }
      if($total_invoice_count==null){
        $total_invoice_count="0";
      }
      if($cash_total==null){
        $cash_total="0";
      }
      if($card_total==null){
        $card_total="0";
      }
      if($cash_and_card_total==null){
        $cash_and_card_total="0";
      }
      if($total==null){
        $total="0";
      }




      $total_cash_count=$data[$i]['total_cash_count'];
      $total_card_count=$data[$i]['total_card_count'];
      $total_cash_and_card_count=$data[$i]['total_cash_and_card_count'];
      $total_count=$data[$i]['total_count'];
      $total_cash_amount=$data[$i]['total_cash_amount'];
      $total_card_amount=$data[$i]['total_card_amount'];
      $total_cash_and_card_amount=$data[$i]['total_cash_and_card_amount'];
      $total_amount=$data[$i]['total_amount'];




    $get_data=[$i+1,$invoice_month,$cash_count,$card_count,$cash_and_card_count,$total_invoice_count,$cash_total,$card_total,$cash_and_card_total,$total];
    $columns[$j]=$get_data;

    $j++;
    }
     $total_array=['','Total',$total_cash_count,$total_card_count,$total_cash_and_card_count,$total_count,$total_cash_amount,$total_card_amount,$total_cash_and_card_amount,$total_amount];
   
    $columns[$j+1]=$total_array;
    return [$columns] ; 

    //End Of Monthly Report
  }

   
    public function registerEvents(): array
    {
      $shouldBeRedNumTransformed = $this->shouldBeRedNum;
    //   foreach ($shouldBeRedNumTransformed as $key => $index) {
    //     $shouldBeRedNumTransformed[$key] = $this->getNameFromNumber($index);
    //   }

      return [
        AfterSheet::class => function (AfterSheet $event) use($shouldBeRedNumTransformed){
          $event->sheet->getStyle('A1:Z1')->applyFromArray(['font' => ['bold' => true]]);  
          $event->sheet->getStyle('A2:Z2')->applyFromArray(['font' => ['bold' => true]]);
           $event->sheet->getStyle('A3:Z3')->applyFromArray(['font' => ['bold' => true]]);
          foreach ($shouldBeRedNumTransformed as $key => $cellNo) {
            $event->sheet
            ->getStyle($cellNo)
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()->setARGB('FFFFF');
          }
          $event->sheet->mergeCells('A1:J1');
        if(session('from_date') && session('to_date'))
        {
          $event->sheet->mergeCells('B2:C2');
          $event->sheet->mergeCells('D2:E2');
        }
       else if(session('from_date')){
            $event->sheet->mergeCells('B2:C2');
       }
       else{

       }


        }
      ];

    }

    private function getNameFromNumber($num) {
      $numeric = ($num - 1) % 26;
      $letter = chr(65 + $numeric);
      $num2 = intval(($num - 1) / 26);
     
      if ($num2 > 0) {
        return $this->getNameFromNumber($num2).$letter ;  
      } else {
        return $letter;
      }
    }

   public function styles(Worksheet $sheet): array
    {
        return [
            'A1:Z1' => [
                'alignment' => [
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                ],
            ],
        ];
    }
}