<?php

namespace App\Exports;

use Illuminate\Support\Facades\DB;
use App\Models\orderModel;
use App\Models\orderitemmodel;
use Maatwebsite\Excel\Concerns\FromArray;
use Maatwebsite\Excel\Concerns\ShouldAutoSize;
use Maatwebsite\Excel\Concerns\WithEvents;
use Maatwebsite\Excel\Events\AfterSheet;
use Maatwebsite\Excel\Events\BeforeExport;
use PhpOffice\PhpSpreadsheet\Worksheet\Worksheet;
use Maatwebsite\Excel\Concerns\WithStyles;


class dailywiseExport implements FromArray,ShouldAutoSize, WithEvents,WithStyles {


    public function  __construct($data)
    {
   
        $this->data= $data;
      

    }

    private $shouldBeRedNum = [1,2,3,4,5,6,7,8,9,10,11];


    public function array(): array
    {
   //Filter Data Section
    $from_data=$to_data="";
      
    if(session('from_date') && session('to_date')){
        if(session('from_date')){
            $from_data="From Date : ".session('from_date');
        }
        if(session('to_date')){
            $to_data="To Date : ".session('to_date');
        }
    }
    else if(session('from_date')){
        $from_data="Date  : ".session('from_date');
    }

    //End Of Filter Data Section


    //Daily Report Starting


    $top_heading = [
        'Daily  Order Report',
      ];

    $date_filter_data=['',$from_data,'',$to_data];
      $heading = [
        '#',
        'Date',
        'APPROVED ORDER	',
        'CANCELLED ORDER',
        'TOTAL ORDER',
        'APPROVED AMT',
        'CANCELLED AMT',
        'TOTAL AMT',
      ];

   


    
 
    $propertyArray = [];
    $columns[0]=$top_heading;
    $columns[1]=$date_filter_data;
    $columns[2]=$heading;

    $order_data=$this->data['data'];
    $total_reviews=0;
    $total_avg_rating=0;

    $j=3;
    for($i=0;$i<count($order_data);$i++){



            $order_date=$order_data[$i]['order_date'];
            $total_order_count=$order_data[$i]['total_order_count'];
            $approved_count=$order_data[$i]['approved_count'];
            $cancelled_count=$order_data[$i]['cancelled_count'];
            $approved_sum=number_format($order_data[$i]['approved_sum'],2);
            $cancelled_sum=number_format($order_data[$i]['cancelled_sum'],2);
            $grand_total=number_format($order_data[$i]['grand_total'],2);


            $total_order=$order_data[$i]['total_order'];
            $total_approved_order=$order_data[$i]['total_approved_order'];
            $total_cancelled_order=$order_data[$i]['total_cancelled_order'];
            $total_order_amount=$order_data[$i]['total_order_amount'];
            $total_approved_amount=$order_data[$i]['total_approved_amount'];
            $total_cancelled_amount=$order_data[$i]['total_cancelled_amount'];



    $get_reports_data=[$i+1,$order_date,$approved_count,$cancelled_count,$total_order_count,$approved_sum,$cancelled_sum,$grand_total];
    $columns[$j]=$get_reports_data;

    $j++;
    }
     $total_array=['','Total',$total_approved_order,$total_cancelled_order,$total_order,$total_approved_amount,$total_cancelled_amount,$total_order_amount];
   
    $columns[$j+1]=$total_array;
    return [$columns] ; 

    //End Of Monthly Report
  }

   
    public function registerEvents(): array
    {
      $shouldBeRedNumTransformed = $this->shouldBeRedNum;
    //   foreach ($shouldBeRedNumTransformed as $key => $index) {
    //     $shouldBeRedNumTransformed[$key] = $this->getNameFromNumber($index);
    //   }

      return [
        AfterSheet::class => function (AfterSheet $event) use($shouldBeRedNumTransformed){
          $event->sheet->getStyle('A1:Z1')->applyFromArray(['font' => ['bold' => true]]);  
          $event->sheet->getStyle('A2:Z2')->applyFromArray(['font' => ['bold' => true]]);
           $event->sheet->getStyle('A3:Z3')->applyFromArray(['font' => ['bold' => true]]);
          foreach ($shouldBeRedNumTransformed as $key => $cellNo) {
            $event->sheet
            ->getStyle($cellNo)
            ->getFill()
            ->setFillType(\PhpOffice\PhpSpreadsheet\Style\Fill::FILL_SOLID)
            ->getStartColor()->setARGB('FFFFF');
          }
          $event->sheet->mergeCells('A1:H1');
        if(session('from_date') && session('to_date'))
        {
          $event->sheet->mergeCells('B2:C2');
          $event->sheet->mergeCells('D2:E2');
        }
       else if(session('from_date')){
            $event->sheet->mergeCells('B2:C2');
       }
       else{

       }


        }
      ];

    }

    private function getNameFromNumber($num) {
      $numeric = ($num - 1) % 26;
      $letter = chr(65 + $numeric);
      $num2 = intval(($num - 1) / 26);
     
      if ($num2 > 0) {
        return $this->getNameFromNumber($num2).$letter ;  
      } else {
        return $letter;
      }
    }

   public function styles(Worksheet $sheet): array
    {
        return [
            'A1:Z1' => [
                'alignment' => [
                    'horizontal' => \PhpOffice\PhpSpreadsheet\Style\Alignment::HORIZONTAL_CENTER,
                ],
            ],
        ];
    }
}