<?php

namespace App\Exports;

use App\Models\customerModel;
use Maatwebsite\Excel\Concerns\FromCollection;
use Maatwebsite\Excel\Concerns\WithHeadings;
use PhpOffice\PhpSpreadsheet\Style\NumberFormat;

class ExportCustomer implements FromCollection, WithHeadings
{
    public function collection()
    {
        return customerModel::select('customer_unique_id', 'customer_name', 'customer_mob', 'customer_mail_id')->get();
    }

    public function headings(): array
    {
        return [
            'Customer ID',
            'Name',
            'Mobile',
            'Email'
        ];
    }

//    public function columnFormats(): array
//    {
//        return [
//            'C' => NumberFormat::FORMAT_TEXT, // Column C = Mobile
//        ];
//    }

    public function map($customer): array
    {
        return [
            $customer->customer_unique_id,
            $customer->customer_name,
            (string) $customer->customer_mob,   // 🔑 Force mobile to string
            $customer->customer_mail_id,
        ];
    }
}
